<?php
include "../koneksi.php";
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Tambah Berita</title>

<style>
body{
    font-family: Arial, sans-serif;
    background:#f3f4f6;
    margin:0;
    min-height:100vh;
    display:flex;
    justify-content:center;
    align-items:center;
}

.card{
    width:100%;
    max-width:650px;
    background:#fff;
    padding:30px;
    border-radius:16px;
    box-shadow:0 10px 30px rgba(0,0,0,.1);
}


.card h2{
    margin-top:0;
    margin-bottom:20px;
}

.form-group{
    margin-bottom:16px;
}

.form-group label{
    display:block;
    margin-bottom:6px;
    font-weight:bold;
}

.form-group input,
.form-group textarea{
    width:100%;
    padding:10px 12px;
    border:1px solid #d1d5db;
    border-radius:10px;
    font-size:14px;
}

.form-group textarea{
    resize:vertical;
    min-height:140px;
}

.form-group input:focus,
.form-group textarea:focus{
    outline:none;
    border-color:#3b82f6;
}

.btn{
    padding:10px 16px;
    border:none;
    border-radius:10px;
    cursor:pointer;
    font-size:14px;
}

.btn-simpan{
    background:#10b981;
    color:#fff;
}

.btn-simpan:hover{
    background:#059669;
}

.btn-kembali{
    background:#e5e7eb;
    color:#111827;
    text-decoration:none;
    margin-left:10px;
}
</style>
</head>

<body>

<div class="card">
    <h2>Tambah Berita</h2>

    <form action="berita_proses_tambah.php" method="post" enctype="multipart/form-data">

        <div class="form-group">
            <label>Judul Berita</label>
            <input type="text" name="judul" placeholder="Judul berita" required>
        </div>

        <div class="form-group">
            <label>Tanggal</label>
            <input type="date" name="tanggal" required>
        </div>

        <div class="form-group">
            <label>Isi Berita</label>
            <textarea name="isi" placeholder="Isi berita" required></textarea>
        </div>

        <div class="form-group">
            <label>Foto Berita</label>
            <input type="file" name="foto" required>
        </div>

        <button type="submit" class="btn btn-simpan">Simpan</button>
        <a href="berita.php" class="btn btn-kembali">Kembali</a>

    </form>
</div>

</body>
</html>
