<?php
session_start();
include "../koneksi.php";

if (!isset($_SESSION['login'])) {
  header("Location: ../login.php");
  exit;
}


// Ambil data statistik
$santri = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM santri"));
$ustadz = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM ustadz"));
$kelas  = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM kelas"));
$berita = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM berita"));
$total_kegiatan = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM kegiatan"));
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Dashboard Admin</title>
  <link rel="stylesheet" href="../assets/style.css">
</head>
<body>

<nav class="navbar">
  <div class="logo">Admin Pesantren</div>
  <ul class="menu">
    <li><a href="dashboard.php">Dashboard</a></li>
    <li><a href="santri.php">Santri</a></li>
    <li><a href="ustadz.php">Ustadz</a></li>
    <li><a href="kelas.php">Kelas</a></li>
    <li><a href="berita.php">Berita</a></li>
    <li><a href="kegiatan.php">Kegiatan</a></li>

    <!-- PEMBATAS -->
    <li style="margin-left:20px">
      <a href="../index.php" target="_blank" class="btn-view">
      Lihat Website
      </a>
    </li>

    <li>
      <a href="../logout.php" class="btn-logout">Logout</a>
    </li>
  </ul>
</nav>


<!-- DASHBOARD -->
<div class="dashboard">
  <h1>
  Selamat Datang, 
  <?= isset($_SESSION['username']) ? $_SESSION['username'] : 'Admin'; ?> 
</h1>

  <div class="cards">
    <div class="card">
      <h3>Total Santri</h3>
      <span><?= $santri; ?></span>
    </div>

    <div class="card">
      <h3>Total Ustadz</h3>
      <span><?= $ustadz; ?></span>
    </div>

    <div class="card">
      <h3>Total Kelas</h3>
      <span><?= $kelas; ?></span>
    </div>

    <div class="card">
      <h3>Total Berita</h3>
      <span><?= $berita; ?></span>
    </div>

    <div class="card">
      <h3>Total Kegiatan</h3>
      <span><?= $total_kegiatan; ?></span>
    </div>
    
  </div>
</div>

</body>
</html>
