<?php
include "../koneksi.php";
include "inc/navbar.php";
$query = mysqli_query($conn, "SELECT * FROM kelas");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Data Kelas</title>

<style>
body{
    font-family: Arial, sans-serif;
    background:#f3f4f6;
    margin:0;
}

.card{
    background:#fff;
    max-width:1000px;
    margin:40px auto;
    padding:25px;
    border-radius:16px;
    box-shadow:0 10px 30px rgba(0,0,0,.1);
}

.header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:20px;
}

.header h2{
    margin:0;
}

.btn-add{
    background:#10b981;
    color:#fff;
    padding:10px 16px;
    border-radius:10px;
    text-decoration:none;
    font-size:14px;
}

.btn-add:hover{
    background:#059669;
}

table{
    width:100%;
    border-collapse:collapse;
}

thead{
    background:#1f2937;
    color:#fff;
}

th, td{
    padding:12px;
    text-align:left;
}

tbody tr{
    border-bottom:1px solid #e5e7eb;
}

tbody tr:hover{
    background:#f9fafb;
}

.btn{
    padding:6px 12px;
    border-radius:8px;
    color:#fff;
    text-decoration:none;
    font-size:13px;
}

.btn-edit{
    background:#3b82f6;
}

.btn-hapus{
    background:#ef4444;
}
</style>
</head>

<body>

<div class="card">
    <div class="header">
        <h2>Data Kelas</h2>
        <a href="kelas_tambah.php" class="btn-add">+ Tambah Kelas</a>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Kelas</th>
                <th>Wali Kelas</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
        <?php $no=1; while($row=mysqli_fetch_assoc($query)): ?>
            <tr>
                <td><?= $no++; ?></td>
                <td><?= $row['nama_kelas']; ?></td>
                <td><?= $row['wali_kelas']; ?></td>
                <td>
                    <a href="kelas_edit.php?id=<?= $row['id_kelas']; ?>" class="btn btn-edit">Edit</a>
                    <a href="kelas_hapus.php?id=<?= $row['id_kelas']; ?>" 
                       class="btn btn-hapus"
                       onclick="return confirm('Yakin hapus kelas ini?')">
                       Hapus
                    </a>
                </td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div>

</body>
</html>
